function c_n = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,...
    D_center,eps_reg,eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,n_pt_y,...
    nu,N,T,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_minus,y_plus)
%
% Computes the coefficients c_n for an expansion of minus sigma_C in first-kind Chebyshev
% polynomials.
%
z_j = -cos( pi*((1:N)-0.5)/N ); % first-kind Chebyshev points
Delta_y = y_plus-y_minus;
y_barbar = (y_minus+y_plus)/2;
y_j = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points; y_minus < y < y_plus
[~,~,~,sigma_C] = ...
    fault_slip_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,...
    flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,n_pt_y,nu,p_0_center,p_inc,...
    phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_j,y_j);
c_n = ( (2/N) * -sigma_C * T )'; % note minus sign before sigma_C 
